/***********************************************************************
 * Fichero: sha1.js
 * Descripcin: JavaScript Algoritmo SHA-1 para mensajes de 
 *              long bits mxima de 55 caracteres.
 *
 * Autor: PG - SERMEPA 10/12/1999
 *
 ***********************************************************************/
var H1 = 0x67452301;
var H2 = 0xefcdab89;
var H3 = 0x98badcfe;
var H4 = 0x10325476;
var H5 = 0xc3d2e1f0;

function hash(cadena)
{
	buffer=new Array();

	/* Nmero de bytes */
	var longitud=cadena.length;
	var longbits=longitud*8;
	var cadenaLen=String.fromCharCode(0x0,0x0,0x0,0x0,((longbits >>> 24) & 0xff),((longbits >>> 16) & 0xff),((longbits >>> 8) & 0xff),(longbits  & 0xff));
	var index=0;
	var padding=String.fromCharCode(0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
								0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
								0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
								0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
								0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
								0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
								0x0,0x0,0x0,0x0);


	iniciar();

	if(longitud >= 64){
		/* Procesar bloques de 64 */
		for (indice = 0; indice + 63 < longitud; indice += 64){
			transformar(cadena.substr(indice,64));
			index+=64
		}
	}
  	longitud-=index;

  	/* Padding */  
  	padLen = (longitud < 56) ? (56 - longitud) : (120 - longitud);

  
  	if(longitud < 56)
  		transformar(cadena.substr(index)+padding.substr(0,padLen)+cadenaLen);
	else{
		transformar(cadena.substr(index)+padding.substr(0,padLen-56));
		transformar(padding.substr(padLen-56, 56)+cadenaLen);
  	}

	/*
	 * Se pasa a hexadecimal (string)
	 */
	return (word_string(H1)+word_string(H2)+word_string(H3)+word_string(H4)+word_string(H5));

}/* Fin funcin hash */

function iniciar()
{
	H1 = 0x67452301;
	H2 = 0xefcdab89;
	H3 = 0x98badcfe;
	H4 = 0x10325476;
	H5 = 0xc3d2e1f0;
}

function transformar(cadena)
{
	var Y1 = 0x5a827999;
	var Y2 = 0x6ed9eba1;
	var Y3 = 0x8f1bbcdc;
	var Y4 = 0xca62c1d6;

	buffer=new Array();
	words=new Array();

	for(i=0;i<cadena.length;i++)
	{
	  buffer[i]=cadena.charCodeAt(i);
	}

	/* Pasar  bloque de 64 bytes a 16 words */
	for(i=0,j=0;i<64;i+=4,j++)
	{
	  words[j]=((buffer[i + 0] << 24) & 0xff000000)|((buffer[i + 1] << 16) & 0x00ff0000) |
			   ((buffer[i + 2] <<  8) & 0x0000ff00)|(buffer[i + 3] & 0x000000ff);
	}

	/* Procesar */
	for (i = 16; i <= 79; i++)
	{
		t = words[i - 3]^ words[i - 8]^ words[i - 14]^ words[i - 16];
		words[i] = circularRotate(t, 1);
	}

	// Comienzo calculo SHA1
	var A = H1;
	var B = H2;
	var C = H3;
	var D = H4;
	var E = H5;
	var t;
	/*
	 * vuelta 1
	 */
	for (j = 0; j <= 19; j++)
	{
		t = circularRotate(A, 5) + f(B, C, D) + E + words[j] + Y1;
		E = D;	D = C;	C = circularRotate(B, 30);	B = A;	A = t;
	}

	/*
	 * vuelta 2
	 */
	for (j = 20; j <= 39; j++)
	{
		t = circularRotate(A, 5) + h(B, C, D) + E + words[j] + Y2;
		E = D;	D = C;	C = circularRotate(B, 30);	B = A;	A = t;
	}

	/*
	 * vuelta 3
	 */
	for (j = 40; j <= 59; j++)
	{
		t = circularRotate(A, 5) + g(B, C, D) + E + words[j] + Y3;
		E = D;	D = C;	C = circularRotate(B, 30);	B = A;	A = t;
	}

	/*
	 * vuelta 4
	 */
	for (j = 60; j <= 79; j++)
	{
		t = circularRotate(A, 5) + h(B, C, D) + E + words[j] + Y4;
		E = D;	D = C;	C = circularRotate(B, 30);	B = A;	A = t;
	}

	H1 += A;
	H2 += B;
	H3 += C;
	H4 += D;
	H5 += E;

}

function circularRotate(x,n)
{
	return (x << n) | (x >>> (32 - n));
}

function f(u,v,w)
{
	return ((u & v) | ((~u) & w));
}

function h(u,v,w)
{
	return (u ^ v ^ w);
}

function g(u,v,w)
{
	return ((u & v) | (u & w) | (v & w));
}

function word_string(a)
{
 	b1 = ((a >>> 28) & 0xf); 
 	b2 = ((a >>> 24) & 0xf); 
 	b3 = ((a >>> 20) & 0xf);
 	b4 = ((a >>> 16) & 0xf);
 	b5 = ((a >>> 12) & 0xf);
 	b6 = ((a >>> 8) & 0xf);
 	b7 = ((a >>> 4) & 0xf);
 	b8 = (a & 0xf);
 	return (b1.toString(16)+b2.toString(16)+b3.toString(16)+b4.toString(16)+ 
         b5.toString(16)+b6.toString(16)+b7.toString(16)+b8.toString(16));
}

function decode(a)
{    
 b1 = ((a >>> 24) & 0xff); 
 b2 = ((a >>> 16) & 0xff);
 b3 = ((a >>> 8) & 0xff);
 b4 = (a & 0xff);
 return (String.fromCharCode(b1,b2,b3,b4));
}

function hmac(clave, texto)
{
	key_1=new Array();
	key_2=new Array();
	words=new Array();

	for(index=0;index<clave.length;index++)
		key_1[index]=clave.charCodeAt(index);

	for(;index<64;index++)
		key_1[index]=0x0;

	for(index=0;index<64;index++){
		key_2[index]=key_1[index]^0x5c;
	  	key_1[index]^=0x36;
	}

	clave_1=String.fromCharCode(key_1[0],key_1[1],key_1[2],key_1[3],key_1[4],key_1[6],key_1[7],key_1[8],key_1[9],key_1[10],
						    key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],
							key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],
							key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],
							key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],
							key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],key_1[0],
							key_1[0],key_1[0],key_1[0],key_1[0]);
	
	/* Append con texto */	
	hash(String.fromCharCode(key_1)+texto);
	var digest=decode(H1)+decode(H2)+decode(H3)+decode(H4);

	/* Append con clave */	
	return(hash(String.fromCharCode(key_2)+digest));
}


/*
 * A JavaScript implementation of the Secure Hash Algorithm, SHA-1, as defined
 * in FIPS PUB 180-1
 * Version 2.1a Copyright Paul Johnston 2000 - 2002.
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for details.
 */

/*
 * Configurable variables. You may need to tweak these to be compatible with
 * the server-side, but the defaults work in most cases.
 */
var hexcase = 0;  /* hex output format. 0 - lowercase; 1 - uppercase        */
var b64pad  = ""; /* base-64 pad character. "=" for strict RFC compliance   */
var chrsz   = 8;  /* bits per input character. 8 - ASCII; 16 - Unicode      */

/*
 * These are the functions you'll usually want to call
 * They take string arguments and return either hex or base-64 encoded strings
 */
function hex_sha1(s){return binb2hex(core_sha1(str2binb(s),s.length * chrsz));}
function b64_sha1(s){return binb2b64(core_sha1(str2binb(s),s.length * chrsz));}
function str_sha1(s){return binb2str(core_sha1(str2binb(s),s.length * chrsz));}
function hex_hmac_sha1(key, data){ return binb2hex(core_hmac_sha1(key, data));}
function b64_hmac_sha1(key, data){ return binb2b64(core_hmac_sha1(key, data));}
function str_hmac_sha1(key, data){ return binb2str(core_hmac_sha1(key, data));}

/*
 * Perform a simple self-test to see if the VM is working
 */
function sha1_vm_test()
{
  return hex_sha1("abc") == "a9993e364706816aba3e25717850c26c9cd0d89d";
}

/*
 * Calculate the SHA-1 of an array of big-endian words, and a bit length
 */
function core_sha1(x, len)
{
  /* append padding */
  x[len >> 5] |= 0x80 << (24 - len % 32);
  x[((len + 64 >> 9) << 4) + 15] = len;

  var w = Array(80);
  var a =  1732584193;
  var b = -271733879;
  var c = -1732584194;
  var d =  271733878;
  var e = -1009589776;

  for(var i = 0; i < x.length; i += 16)
  {
    var olda = a;
    var oldb = b;
    var oldc = c;
    var oldd = d;
    var olde = e;

    for(var j = 0; j < 80; j++)
    {
      if(j < 16) w[j] = x[i + j];
      else w[j] = rol(w[j-3] ^ w[j-8] ^ w[j-14] ^ w[j-16], 1);
      var t = safe_add(safe_add(rol(a, 5), sha1_ft(j, b, c, d)),
                       safe_add(safe_add(e, w[j]), sha1_kt(j)));
      e = d;
      d = c;
      c = rol(b, 30);
      b = a;
      a = t;
    }

    a = safe_add(a, olda);
    b = safe_add(b, oldb);
    c = safe_add(c, oldc);
    d = safe_add(d, oldd);
    e = safe_add(e, olde);
  }
  return Array(a, b, c, d, e);

}

/*
 * Perform the appropriate triplet combination function for the current
 * iteration
 */
function sha1_ft(t, b, c, d)
{
  if(t < 20) return (b & c) | ((~b) & d);
  if(t < 40) return b ^ c ^ d;
  if(t < 60) return (b & c) | (b & d) | (c & d);
  return b ^ c ^ d;
}

/*
 * Determine the appropriate additive constant for the current iteration
 */
function sha1_kt(t)
{
  return (t < 20) ?  1518500249 : (t < 40) ?  1859775393 :
         (t < 60) ? -1894007588 : -899497514;
}

/*
 * Calculate the HMAC-SHA1 of a key and some data
 */
function core_hmac_sha1(key, data)
{
  var bkey = str2binb(key);
  if(bkey.length > 16) bkey = core_sha1(bkey, key.length * chrsz);

  var ipad = Array(16), opad = Array(16);
  for(var i = 0; i < 16; i++)
  {
    ipad[i] = bkey[i] ^ 0x36363636;
    opad[i] = bkey[i] ^ 0x5C5C5C5C;
  }

  var hash = core_sha1(ipad.concat(str2binb(data)), 512 + data.length * chrsz);
  return core_sha1(opad.concat(hash), 512 + 160);
}

/*
 * Add integers, wrapping at 2^32. This uses 16-bit operations internally
 * to work around bugs in some JS interpreters.
 */
function safe_add(x, y)
{
  var lsw = (x & 0xFFFF) + (y & 0xFFFF);
  var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return (msw << 16) | (lsw & 0xFFFF);
}

/*
 * Bitwise rotate a 32-bit number to the left.
 */
function rol(num, cnt)
{
  return (num << cnt) | (num >>> (32 - cnt));
}

/*
 * Convert an 8-bit or 16-bit string to an array of big-endian words
 * In 8-bit function, characters >255 have their hi-byte silently ignored.
 */
function str2binb(str)
{
  var bin = Array();
  var mask = (1 << chrsz) - 1;
  for(var i = 0; i < str.length * chrsz; i += chrsz)
    bin[i>>5] |= (str.charCodeAt(i / chrsz) & mask) << (32 - chrsz - i%32);
  return bin;
}

/*
 * Convert an array of big-endian words to a string
 */
function binb2str(bin)
{
  var str = "";
  var mask = (1 << chrsz) - 1;
  for(var i = 0; i < bin.length * 32; i += chrsz)
    str += String.fromCharCode((bin[i>>5] >>> (32 - chrsz - i%32)) & mask);
  return str;
}

/*
 * Convert an array of big-endian words to a hex string.
 */
function binb2hex(binarray)
{
  var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
  var str = "";
  for(var i = 0; i < binarray.length * 4; i++)
  {
    str += hex_tab.charAt((binarray[i>>2] >> ((3 - i%4)*8+4)) & 0xF) +
           hex_tab.charAt((binarray[i>>2] >> ((3 - i%4)*8  )) & 0xF);
  }
  return str;
}

/*
 * Convert an array of big-endian words to a base-64 string
 */
function binb2b64(binarray)
{
  var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  var str = "";
  for(var i = 0; i < binarray.length * 4; i += 3)
  {
    var triplet = (((binarray[i   >> 2] >> 8 * (3 -  i   %4)) & 0xFF) << 16)
                | (((binarray[i+1 >> 2] >> 8 * (3 - (i+1)%4)) & 0xFF) << 8 )
                |  ((binarray[i+2 >> 2] >> 8 * (3 - (i+2)%4)) & 0xFF);
    for(var j = 0; j < 4; j++)
    {
      if(i * 8 + j * 6 > binarray.length * 32) str += b64pad;
      else str += tab.charAt((triplet >> 6*(3-j)) & 0x3F);
    }
  }
  return str;
}

